/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction.util;

import java.util.MissingResourceException;

import com.zynaptic.reaction.Logger;

/**
 * Defines the API used by the Reaction package to access message loggers for a
 * suitable log service. For example, standard POJO environments can use this
 * interface to wrap <code>java.util.logging</code> and OSGi environments can
 * use it to wrap <code>org.osgi.service.log</code>.
 * 
 * @author Chris Holgate
 */
public interface ReactorLogTarget {

  /**
   * Gets the runtime message logger which is associated with the specified
   * logger ID. If a message logger for the specified logger ID already exists
   * this will be returned to the caller. If no message logger for the specified
   * logger ID currently exists a new logger object will be created and
   * returned.
   * 
   * @param loggerId
   *          This is the logger ID which is associated with the requested
   *          message logger. This is a String value which will normally hold
   *          the canonical name of the client class which is using the logger.
   * @param loggerResources
   *          This is the name of a ResourceBundle which is to be used for
   *          localising messages for this logger. May be null if none of the
   *          messages require localisation.
   * @return Returns a logger object which may be used for logging runtime
   *         messages.
   * @throws MissingResourceException
   *           This exception will be thrown if a set of logger resources have
   *           been specified but cannot be found.
   */
  public Logger getLogger(String loggerId, String loggerResources)
      throws MissingResourceException;

}