/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction.util;

/**
 * Specifies the interface to a generic monotonic clock source. This interface
 * defines the way in which a reactor component can access a suitable monotonic
 * clock for use as its timebase. Various underlying implementations may be
 * used, depending on the Java version in use and the underlying platform
 * support for monotonic clocks.
 * 
 * @author Chris Holgate
 * 
 */
public interface MonotonicClockSource {

  /**
   * Initialises the monotonic clock source. This method is called on startup by
   * the reactor in order to initialise the timebase clock. It resets the
   * current clock time value to 0 and then sets the timer counter running.
   */
  public void init();

  /**
   * Gets the elapsed time since the monotonic clock source was initialised.
   * This method is called in order to obtain the current time, defined as the
   * integer number of milliseconds since the monotonic clock source was
   * initialised.
   * 
   * @return Returns the monotonic time since the clock was initialised,
   *         specified in milliseconds. Returns invalid data if the clock has
   *         not been initialised.
   */
  public long getMsTime();

}
