/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction.util;

/**
 * Implements a monotonic clock source using the standard Java monotonic clock.
 * This monotonic clock variant makes use of the <code>nanoTime</code> system
 * call which provides a monotonic clock source on supported platforms. Note
 * that some platforms, including many standard Linux distributions, do not
 * provide native monotonic clock support and these should use the fixed up
 * monotonic clock source instead.
 * <p>
 * This simple implementation does not wrap correctly and will fail after 292
 * years of uptime.
 * 
 * @author Chris Holgate
 */
public final class JavaMonotonicClock implements MonotonicClockSource {

  // Used to offset the clock so that it represents the reactor uptime.
  private long timeOffset = 0;

  /*
   * Implements MonotonicClockSource.getMsTime()
   */
  public final synchronized long getMsTime() {
    return (System.nanoTime() - timeOffset) / 1000000;
  }

  /*
   * Implements MonotonicClockSource.init()
   */
  public final synchronized void init() {
    timeOffset = System.nanoTime();
  }
}
