/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction;

/**
 * Defines the interface to a timeable object. Timeable objects can be submitted
 * to the reactor in order to request timed callbacks via this interface. Timed
 * callbacks may be one-shot or repeating, depending on which method was used to
 * submit them to the reactor.
 * 
 * @param <T>
 *          This type parameter specifies the type of timer data objects which
 *          may be accepted by the timeable object.
 * 
 * @author Chris Holgate
 */
public interface Timeable<T> {

  /**
   * Receives a timed event callback from the reactor. This method is executed
   * by the reactor in response to a timed event. Depending on context, this may
   * either be a one-shot event or repeated at intervals.
   * 
   * @param data
   *          This is the timer data object which was associated with the timed
   *          event when it was submitted to the reactor.
   */
  public void onTick(T data);

}
