/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction;

/**
 * Defines the interface to a signalable object. Signalable objects implement
 * this interface as a means of receiving signal event notifications from the
 * reactor. This provides a mechanism for broadcasting signal events to multiple
 * listeners.
 * <p>
 * Note that objects implementing this interface must not attempt to override
 * the default 'equals' method since this is used as an identity test within the
 * reactor core.
 * 
 * @param <T>
 *          This type parameter specifies the type of signal data which can be
 *          accepted by the signalable object.
 * 
 * @author Chris Holgate
 */
public interface Signalable<T> {

  /**
   * Receives a signal callback from the reactor. This method is called whenever
   * a signal is generated to which the signalable object is subscribed.
   * 
   * @param signalId
   *          This is a handle on a signal event object which may be used to
   *          identify the source of the signal being raised.
   * @param data
   *          This is the signal data object which is passed as a parameter to
   *          the signal event. It should be treated as an immutable object and
   *          no attempt should be made to change the state of this object
   *          within the callback.
   */
  public void onSignal(Signal<T> signalId, final T data);

}