/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction;

/**
 * Indicates an attempt to make an invalid call from a signal callback. This
 * exception is thrown if an attempt is made to generate a signal event or
 * modify the list of signal subscribers from the context of a signal callback
 * routine.
 * 
 * @author Chris Holgate
 */
public class SignalContextException extends ReactionRuntimeException {
  private static final long serialVersionUID = -9105840507592367165L;

  /**
   * Constructs a new signal call context exception. The only supported
   * constructor for this class of exception is the standard string message
   * constructor.
   * 
   * @param msg
   *          This is the message string which is used to describe the error
   *          condition.
   */
  public SignalContextException(String msg) {
    super(msg);
  }
}
