/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction;

/**
 * Indicates an attempt to access the reactor when it is not running. This
 * exception is thrown if an attempt is made to access the reactor while it is
 * in its stopped state. This is implemented as a runtime exception, since it
 * implies a bug whereby a client of the reactor has not been correctly
 * monitoring the reactor state.
 * 
 * @author Chris Holgate
 */
public class ReactorNotRunningException extends ReactionRuntimeException {
  private static final long serialVersionUID = -106155811856892741L;

  /**
   * Constructs a new reactor not running exception. The only supported
   * constructor for this class of exception is the standard string message
   * constructor.
   * 
   * @param msg
   *          This is the message string which is used to describe the error
   *          condition.
   */
  public ReactorNotRunningException(String msg) {
    super(msg);
  }
}
