/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction;

/**
 * Indicates an invalid attempt to trigger a deferred event object. This
 * exception is thrown when an attempt is made to trigger a deferred event
 * object more than once. It is only legitimate to make a single call to either
 * the {@link Deferred#callback(Object) callback} or
 * {@link Deferred#errback(Exception) errback} method on a given deferred event
 * object. Anything else constitutes a programming error and is indicated by
 * this exception.
 * 
 * @author Chris Holgate
 */
public class DeferredTriggeredException extends ReactionRuntimeException {
  private static final long serialVersionUID = 1596314493221746118L;

  /**
   * Constructs a new deferred triggered exception. The only supported
   * constructor for this class of exception is the standard string message
   * constructor.
   * 
   * @param msg
   *          This is the message string which is used to describe the error
   *          condition.
   */
  public DeferredTriggeredException(String msg) {
    super(msg);
  }
}
