/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction.examples.timer;

import com.zynaptic.reaction.Reactor;
import com.zynaptic.reaction.Timeable;
import com.zynaptic.reaction.core.ReactorCore;
import com.zynaptic.reaction.core.ReactorControl;
import com.zynaptic.reaction.util.FixedUpMonotonicClock;
import com.zynaptic.reaction.util.ReactorLogSystemOut;

/**
 * Example of the one-shot timer cancellation.
 */
public class OneShotTimerExample2 {
  public static void main(String[] args) throws InterruptedException {

    // Get a handle on the reactor interfaces.
    ReactorControl reactorCtrl = ReactorCore.getReactorControl();
    Reactor reactor = ReactorCore.getReactor();

    // Start the reactor using the specified monotonic clock and log
    // service.
    System.out.println("Starting up reactor.");
    reactorCtrl.start(new FixedUpMonotonicClock(), new ReactorLogSystemOut());

    // Request a callback from a one-shot timer.
    reactor.runTimerOneShot(new TimerCallback(), 5000, reactorCtrl);

    // Request a callback which will throw an exception.
    Timeable<ReactorControl> badCallback = new TimerCallback();
    reactor.runTimerOneShot(badCallback, 1000, null);

    // Cancel the erroneous callback.
    reactor.cancelTimer(badCallback);

    // Wait for the reactor to stop running.
    reactorCtrl.join();
    System.exit(0);
  }

  /**
   * The timer callback implementation just stops the reactor when called.
   */
  private static class TimerCallback implements Timeable<ReactorControl> {
    public void onTick(ReactorControl reactorCtrl) {
      System.out.println("Detected one-shot timeout.");
      reactorCtrl.stop();
    }
  }
}
