/*
 * Zynaptic Reaction - An asynchronous programming framework for Java.
 * 
 * Copyright (c) 2009-2012, Zynaptic Limited. All rights reserved. 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 only, as published by
 * the Free Software Foundation. Zynaptic Limited designates this particular
 * file as subject to the "Classpath" exception as provided in the LICENSE
 * file that accompanied this code.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version 2
 * along with this work; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please visit www.zynaptic.com or contact reaction@zynaptic.com if you need
 * additional information or have any questions.
 */

package com.zynaptic.reaction.examples.reactor;

import com.zynaptic.reaction.Reactor;
import com.zynaptic.reaction.core.ReactorCore;
import com.zynaptic.reaction.core.ReactorControl;
import com.zynaptic.reaction.util.FixedUpMonotonicClock;
import com.zynaptic.reaction.util.ReactorLogSystemOut;

/**
 * Reactor uptime example. This starts up and then shuts down the reactor from
 * the main application thread, checking the reactor uptime in the process.
 */
public class ReactorUptimeExample {
  public static void main(String[] args) throws InterruptedException {

    // Obtain a handle on the reactor control and user interfaces.
    ReactorControl reactorCtrl = ReactorCore.getReactorControl();
    Reactor reactor = ReactorCore.getReactor();

    // Start the reactor using the specified monotonic clock and log service.
    System.out.println("Starting up reactor.");
    reactorCtrl.start(new FixedUpMonotonicClock(), new ReactorLogSystemOut());

    // Check the reactor uptime - finish test after 10 seconds of uptime.
    long reactorUptime;
    do {
      Thread.sleep(1000);
      reactorUptime = reactor.getUptime();
      System.out.println("Current reactor uptime = " + reactorUptime + " ms.");
    } while (reactorUptime < 10000);

    // Request that the reactor stop running.
    System.out.println("Request reactor stop.");
    reactorCtrl.stop();

    // Wait for the reactor to stop running.
    reactorCtrl.join();
    System.out.println("Reactor stopped.");
    System.exit(0);
  }
}
